

public class ComputerScienceStudent extends UndergradStudent
{
	private static double[] fracWordsFromGenStudies = new double[]{1, .5, .25, 0};
	
	private String[] csWordSet;
	/**
	 * general constructor.  We will use it to show method
	 * overloading.
	 * @param name
	 * @param major
	 * @param schoolYear
	 * @throws InvalidFieldValueException
	 */
	public ComputerScienceStudent(String name,
			int schoolYear) throws InvalidFieldValueException 
	{
		super(name, "Computer Science", schoolYear);
		
		String[] oldWordSet = this.getWordSet();
		csWordSet = new String[]{"computer", "science", "math",
				"algorithms", "data", "structures", "error",
				"computer","science", "cs","problem","estimates",
				"programming","java","cornell", "abstract"};
		
		//Each year students are in in the CS program, they lose some previously
		//learned vocabulary
		String[] newWordSet = new String[csWordSet.length+
		           (int)(fracWordsFromGenStudies[schoolYear-1]*csWordSet.length)];
		for (int i = 0; i < csWordSet.length; i++){
			newWordSet[i] = csWordSet[i];
		}
		for (int i = csWordSet.length; i < newWordSet.length; i++) {
			newWordSet[i] = oldWordSet[i-csWordSet.length];
		}
		this.setWordSet(newWordSet);
		
	}
	/**
	 * constructor that assumes that the computer science.
	 * student is a freshman.
	 * This is an example of _method overloading_: we 
	 * have 2 constructors with the same name but different 
	 * signatures.
	 * @param name
	 * @param major
	 * @throws InvalidFieldValueException 
	 */
	public ComputerScienceStudent(String name) 
							throws InvalidFieldValueException
	{
		//this allows us to call a constructor in the same class
		this(name, 1);
	}
	
	@Override
	public String[] getMajorSpecificVocabulary() {
		return csWordSet;
	}
}
